/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v3.levelgen.features.config;

import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.WeightedStateProvider;

public abstract class PlaceBlockFeatureConfig
implements FeatureConfiguration {
    protected final BlockStateProvider stateProvider;

    protected static <T extends PlaceBlockFeatureConfig> RecordCodecBuilder<T, BlockStateProvider> blockStateCodec() {
        return BlockStateProvider.f_68747_.fieldOf("entries").forGetter(o -> o.stateProvider);
    }

    protected static SimpleWeightedRandomList<BlockState> buildWeightedList(List<BlockState> states) {
        SimpleWeightedRandomList.Builder builder = SimpleWeightedRandomList.m_146263_();
        for (BlockState s : states) {
            builder.m_146271_((Object)s, 1);
        }
        return builder.m_146270_();
    }

    protected static SimpleWeightedRandomList<BlockState> buildWeightedList(BlockState state) {
        return SimpleWeightedRandomList.m_146263_().m_146271_((Object)state, 1).m_146270_();
    }

    public PlaceBlockFeatureConfig(Block block) {
        this(block.m_49966_());
    }

    public PlaceBlockFeatureConfig(BlockState state) {
        this((BlockStateProvider)BlockStateProvider.m_191384_((BlockState)state));
    }

    public PlaceBlockFeatureConfig(List<BlockState> states) {
        this(PlaceBlockFeatureConfig.buildWeightedList(states));
    }

    public PlaceBlockFeatureConfig(SimpleWeightedRandomList<BlockState> blocks) {
        this.stateProvider = new WeightedStateProvider(blocks);
    }

    public PlaceBlockFeatureConfig(BlockStateProvider blocks) {
        this.stateProvider = blocks;
    }

    public BlockState getRandomBlock(RandomSource random, BlockPos pos) {
        return this.stateProvider.m_213972_(random, pos);
    }

    public boolean place(FeaturePlaceContext<? extends PlaceBlockFeatureConfig> ctx) {
        BlockState state = this.getRandomBlock(ctx.m_225041_(), ctx.m_159777_());
        return this.placeBlock(ctx, ctx.m_159774_(), ctx.m_159777_(), state);
    }

    protected abstract boolean placeBlock(FeaturePlaceContext<? extends PlaceBlockFeatureConfig> var1, WorldGenLevel var2, BlockPos var3, BlockState var4);
}

